
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_CTRatioReport : BaseTest 
	{

		private System.DateTime _startDate = System.DateTime.Now.AddYears(-5);
		private System.DateTime _endDate = System.DateTime.Now.AddYears(1);

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
		}

		[Test]
		public void GetCTRatioReportCount_Pass()
		{
			int intCount = DAL.CTRatioReport.GetCTRatioReportCount(this._startDate, this._endDate, UnitTestConfig.TestDivisionCode, false);

			Assert.AreEqual(true, intCount >= 0, "ReturnValue");
		}

		[Test]
		public void GetCTRatioReportCount_Fail()
		{		
			int intCount = DAL.CTRatioReport.GetCTRatioReportCount(this._startDate, this._endDate, string.Empty, false);

			Assert.AreEqual(0, intCount, "ReturnValue");
		}
  
		[Test]
		public void GetCTRatioReport_Pass()
		{
			DataTable dtTest = DAL.CTRatioReport.GetCTRatioReport(this._startDate, this._endDate, UnitTestConfig.TestDivisionCode, false);

			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientGuid), TABLES.PatientTreatment.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionCode), TABLES.VamcDivision.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate), TABLES.OrderedUnit.CrossmatchDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode), TABLES.OrderedUnit.CrossmatchResultCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CrossmatchResult.CrossmatchResultText), TABLES.CrossmatchResult.CrossmatchResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderId), TABLES.PatientOrder.OrderingProviderId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatmentGuid), TABLES.PatientTreatment.PatientTreatmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.TreatingSpecialtyCode), TABLES.PatientTreatment.TreatingSpecialtyCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), TABLES.TreatingSpecialty.TreatingSpecialtyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.SortColumn), TABLES.TreatingSpecialty.SortColumn);

		}

		[Test]
		public void GetCTRatioReport_Fail()
		{		
			DataTable dtTest = DAL.CTRatioReport.GetCTRatioReport(this._startDate, this._endDate, string.Empty, false);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}
#endif
